       program Greenhouse Gas Lifecycle Emissions Model
!      Version released 2022 
       implicit none
       real :: refineryCO2, refineryCH4, refineryprocessing, oilsnc
       real :: ngsystemCO2, ngsystemCH4, ngsystemprocessing, ngasnc
       real :: coalpostCO2, coalpostCH4, coalpostprocessing, coalnc
       real :: refineryN2O, ngsystemN2O, coalpostN2O
       real :: oilstotal, ngastotal, coaltotal
       real :: oilsprod, ngasprod, coalprod
       real :: CO2onem, CH4onem, N2Oonem, CO2Eonem
       real :: oilsconsumpCO2,oilsconsumpCH4,oilsconsumpN2O,
     #                     oilsconsumpCO2E
       real :: ngasconsumpCO2,ngasconsumpCH4,ngasconsumpN2O,
     #                     ngasconsumpCO2E
       real :: coalconsumpCO2,coalconsumpCH4,coalconsumpN2O,
     #                     coalconsumpCO2E
       real :: refineryCO2emissions,refineryCH4emissions,
     #           refineryN2Oemissions, refineryCO2Eemissions 
       real :: ngassystemCO2emissions,ngassystemCH4emissions,
     #           ngassystemN2Oemissions, ngassystemCO2Eemissions
       real :: coalpostCO2emissions,coalpostCH4emissions,
     #           coalpostN2Oemissions, coalpostCO2Eemissions
       real :: downCO2, downCH4, downN2O, downCO2E
       real :: midCO2, midCH4, midN2O, midCO2E
       real :: totalCO2,totalCH4,totalN2O,totalCO2E
       character*49 junktext
       integer*2 :: oilsnum,ngasnum,coalnum,areanum
       character*4 pyear,oyear
       integer*8 :: i, j, k, l, m, n
       character*22, dimension (:,:), allocatable :: oilsname,ngasname,
     #      coalname
       character*24, dimension (:,:), allocatable :: prodfilename,
     #      onemfilename, totlfilename, upfilename, midfilename,
     #      downfilename
       integer*4, dimension (:,:), allocatable :: numyears 
       real,dimension (:,:), allocatable :: oilsefactor,ngasefactor,
     #      coalefactor
!      *****************************************************************************
 100  format (i2)
 110  format (i5,i5)
 120  format (F5.1,F5.1,F5.1,F9.0,F6.3)
 200  format (A22,F7.0,F8.6,F11.9,F11.9)
 210  format (A22,F7.0,F8.0,F11.0,F11.0)
 300  format (A24)
 350  format (i3)
 400  format (A4,F13.0,F13.0,F13.0)
 500  format (A4,F14.0,F14.0,F14.0,F14.0)
!  LOAD PARAMETERS

      open (unit=20, file="Processing/fuel_parameters.txt", 
     #                           form="formatted", status="old")
       read (unit=20, fmt=100) oilsnum
       read (unit=20, fmt=100) ngasnum
       read (unit=20, fmt=100) coalnum
       read (unit=20, fmt=100) areanum
      close (20)

      open (unit=21, file="Processing/overall_parameters.txt",
     #                           form="formatted", status="old")
       read (unit=21, fmt=120) refineryCO2, refineryCH4,
     #  refineryN2O, refineryprocessing,oilsnc
       read (unit=21, fmt=120) ngsystemCO2, ngsystemCH4,
     #  ngsystemN2O, ngsystemprocessing,ngasnc
       read (unit=21, fmt=120) coalpostCO2, coalpostCH4,
     #  coalpostN2O, coalpostprocessing,coalnc
      close (21)


!   Prepare all parameters
      if (MOD(areanum,2)==0) then
        areanum = areanum/2
        write (*,*) "Sub-project(s) detected:", areanum
      else
        write(*,*)"Error: prod and onem files are not equal in number.
     # Please correct error, and reprocess model."
      endif
      refineryCO2 = refineryCO2*1000000/(refineryprocessing*1000)
      refineryCH4 = refineryCH4*1000000/(refineryprocessing*1000)
      refineryN2O = refineryN2O*1000/(refineryprocessing*1000)
      ngsystemCO2 = ngsystemCO2*1000000/(ngsystemprocessing*1000)
      ngsystemCH4 = ngsystemCH4*1000000/(ngsystemprocessing*1000)
      ngsystemN2O = ngsystemN2O*1000/(ngsystemprocessing*1000)
      coalpostCO2 = coalpostCO2*1000000/(coalpostprocessing*1000)
      coalpostCH4 = coalpostCH4*1000000/(coalpostprocessing*1000)
      coalpostN2O = coalpostN2O*1000/(coalpostprocessing*1000)

      allocate ( oilsname (1,oilsnum) )      
      allocate ( ngasname (1,ngasnum) )
      allocate ( coalname (1,coalnum) )
      allocate ( oilsefactor (4,oilsnum) )
      allocate ( ngasefactor (4,ngasnum) )
      allocate ( coalefactor (4,coalnum) )
      allocate ( prodfilename (1,areanum) )
      allocate ( onemfilename (1,areanum) )
      allocate ( totlfilename (1,areanum) )
      allocate ( upfilename (1,areanum) )
      allocate ( midfilename (1,areanum) )
      allocate ( downfilename (1,areanum) )
      allocate ( numyears (1,areanum) )


! Oil Emission Factor Loop
! EF for Barrels of oil convered to gallons
      write (*,*) "Preparing oil emission factors."
      open (unit=30, file="Processing/consemis_oils.txt",
     #                            form="formatted", status="old")
       do i=1,oilsnum
        read (unit=30,fmt=200) oilsname(1,i),oilsefactor(1,i),
     #              oilsefactor(2,i),oilsefactor(3,i),oilsefactor(4,i)
           oilstotal = oilstotal + oilsefactor(1,i)
           oilsefactor(2,i) = oilsefactor(2,i)*42
           oilsefactor(3,i) = oilsefactor(3,i)*42
           oilsefactor(4,i) = oilsefactor(4,i)*42
       enddo
      close (30)
! Natural Gas Emission Factor Loop
      write (*,*) "Preparing natural gas emission factors."
      open (unit=31, file="Processing/consemis_ngas.txt",
     #                            form="formatted", status="old")
       do j=1,ngasnum
        read (unit=31,fmt=200) ngasname(1,j),ngasefactor(1,j),
     #              ngasefactor(2,j),ngasefactor(3,j),ngasefactor(4,j)
           ngastotal = ngastotal + ngasefactor(1,j)
           ngasefactor(2,j) = ngasefactor(2,j)
           ngasefactor(3,j) = ngasefactor(3,j)
           ngasefactor(4,j) = ngasefactor(4,j)
       enddo
      close (31)

! Coal Emission Factor Loop
! EF for short tons of coal convered to metric tons
      write (*,*) "Preparing coal emission factors."
      open (unit=32, file="Processing/consemis_coal.txt",
     #                            form="formatted", status="old")
       do k=1,coalnum
        read (unit=32,fmt=210) coalname(1,k),coalefactor(1,k),
     #              coalefactor(2,k),coalefactor(3,k),coalefactor(4,k)
           coaltotal = coaltotal + coalefactor(1,k)
           coalefactor(2,k) = coalefactor(2,k)/0.907185
           coalefactor(3,k) = coalefactor(3,k)/0.907185
           coalefactor(4,k) = coalefactor(4,k)/0.907185
       enddo
      close (32)
! Set Oil, Natural Gas, and Coal Consumption Rates
      write (*,*) "Calculating national consumption patterns."
      do i=1,oilsnum
        oilsefactor(1,i)=oilsefactor(1,i)/oilstotal
      enddo
      do j=1,ngasnum
        ngasefactor(1,j)=ngasefactor(1,j)/ngastotal
      enddo
      do k=1,coalnum
        coalefactor(1,k)=coalefactor(1,k)/coaltotal
      enddo

! Collect Production and Onsite Emission Filenames and Number of Years
      open (unit=40, file="Processing/project_areas.txt",
     #                            form="formatted", status="old")
      open (unit=41, file="Processing/numyears.txt",
     #                            form="formatted", status="old")
       do l=1,areanum
        read (unit=40,fmt=300) onemfilename(1,l)
       enddo
       do l=1,areanum
        read (unit=40,fmt=300) prodfilename(1,l)
       enddo
       do l=1,areanum
        read (unit=41,fmt=350) numyears (1,l)
       enddo
      close (40)
      close (41)


! Read in Production and Onsite Emission Data
      do m=1,areanum
       write (*,*) "Matching production file:  ",prodfilename(1,m)
       write (*,*) "with onsite emission file: ",onemfilename(1,m)
       open (unit=50, file=prodfilename(1,m),
     #                            form="formatted", status="old")
       open (unit=51, file=onemfilename(1,m),
     #                            form="formatted", status="old")
!  Setup files for writting total output
        totlfilename(1,m)(1:11) = prodfilename(1,m)(1:11)
        totlfilename(1,m)(12:15) = "totl"
        totlfilename(1,m)(16:24) = prodfilename(1,m)(16:24)
       open (unit=60, file=totlfilename(1,m),
     #                            form="formatted",status="unknown")
       write (*,*) "Preparing main output file:",totlfilename(1,m)
!  Setup files for writting upsteam output
        upfilename(1,m)(1:11) = prodfilename(1,m)(1:11)
        upfilename(1,m)(12:15) = "upst"
        upfilename(1,m)(16:24) = prodfilename(1,m)(16:24)
       open (unit=61, file=upfilename(1,m),
     #                            form="formatted",status="unknown")
       write (*,*) "Preparing upsteam output file:",upfilename(1,m)
!  Setup files for writting midstream output
        midfilename(1,m)(1:11) = prodfilename(1,m)(1:11)
        midfilename(1,m)(12:15) = "mdst"
        midfilename(1,m)(16:24) = prodfilename(1,m)(16:24)
       open (unit=62, file=midfilename(1,m),
     #                            form="formatted",status="unknown")
       write (*,*) "Preparing midstream output file:",midfilename(1,m)
!  Setup files for writting total output
        downfilename(1,m)(1:11) = prodfilename(1,m)(1:11)
        downfilename(1,m)(12:15) = "dnst"
        downfilename(1,m)(16:24) = prodfilename(1,m)(16:24)
       open (unit=63, file=downfilename(1,m),
     #                            form="formatted",status="unknown")
       write (*,*) "Preparing downstream output file:",downfilename(1,m)

       do n=1,numyears(1,m)
         read (unit=50, fmt=400) pyear,oilsprod,ngasprod,coalprod
         read (unit=51, fmt=400) oyear,CO2onem,CH4onem,N2Oonem
         oilsconsumpCO2 = 0
         oilsconsumpCH4 = 0
         oilsconsumpN2O = 0
         ngasconsumpCO2 = 0
         ngasconsumpCH4 = 0
         ngasconsumpN2O = 0
         coalconsumpCO2 = 0
         coalconsumpCH4 = 0
         coalconsumpN2O = 0
! Calculate Oil Consumption Emissions (kg to metric tons)
       write (*,*) "Calculating Oil Consumption Emissions."
       do i=1,oilsnum
        oilsconsumpCO2 = oilsconsumpCO2 +
     #oilsprod*1.062*oilsefactor(1,i)*(1-oilsnc)*oilsefactor(2,i)/1000
        oilsconsumpCH4 = oilsconsumpCH4 +
     #oilsprod*1.062*oilsefactor(1,i)*(1-oilsnc)*oilsefactor(3,i)/1000
        oilsconsumpN2O = oilsconsumpN2O +
     #oilsprod*1.062*oilsefactor(1,i)*(1-oilsnc)*oilsefactor(4,i)/1000
        if (i==oilsnum) then
          oilsconsumpCO2E = oilsconsumpCO2 + oilsconsumpCH4*25 +
     #         oilsconsumpN2O*298
        endif
       enddo
! Calculate Natural Gas Consumption Emissions (kg to metric tons)
       write (*,*) "Calculating Natural Gas Consumption Emissions."
       do j=1,ngasnum
        ngasconsumpCO2 = ngasconsumpCO2 +
     #    ngasprod*ngasefactor(1,j)*(1-ngasnc)*ngasefactor(2,j)
        ngasconsumpCH4 = ngasconsumpCH4 +
     #    ngasprod*ngasefactor(1,j)*(1-ngasnc)*ngasefactor(3,j)
        ngasconsumpN2O = ngasconsumpN2O +
     #    ngasprod*ngasefactor(1,j)*(1-ngasnc)*ngasefactor(4,j)
        if (j==ngasnum) then
          ngasconsumpCO2E = ngasconsumpCO2 + ngasconsumpCH4*25 +
     #         ngasconsumpN2O*298
        endif
       enddo
! Calculate Coal Consumption Emissions (kg to metric tons)
       write (*,*) "Calculating Coal Consumption Emissions"
       do k=1,coalnum
        coalconsumpCO2 = coalconsumpCO2 +
     #    coalprod*coalefactor(1,k)*(1-coalnc)*coalefactor(2,k)/1000
        coalconsumpCH4 = coalconsumpCH4 +
     #    coalprod*coalefactor(1,k)*(1-coalnc)*coalefactor(3,k)/1000
        coalconsumpN2O = coalconsumpN2O +
     #    coalprod*coalefactor(1,k)*(1-coalnc)*coalefactor(4,k)/1000
        if (k==coalnum) then
          coalconsumpCO2E = coalconsumpCO2 + coalconsumpCH4*25 +
     #         coalconsumpN2O*298
        endif
       enddo

! Calculate Total Downstream Emissions
      write (*,*) "Calculating Downstream Emissions"
      downCO2 = oilsconsumpCO2 + ngasconsumpCO2 + coalconsumpCO2
      downCH4 = oilsconsumpCH4 + ngasconsumpCH4 + coalconsumpCH4
      downN2O = oilsconsumpN2O + ngasconsumpN2O + coalconsumpN2O
      downCO2E = downCO2 + downCH4*25 + downN2O*298

! Calculate Refinery Emissions
      write (*,*) "Calculating Oil Refinery Emissions"
      refineryCO2emissions = refineryCO2*oilsprod
      refineryCH4emissions = refineryCH4*oilsprod
      refineryN2Oemissions = refineryN2O*oilsprod
      refineryCO2Eemissions = refineryCO2emissions 
     #      + refineryCH4emissions*25 + refineryN2Oemissions*298
! Caluclate Natural Gas Storage/Transmission Emissions
      write (*,*) "Calculating Natural Gas Systems Emissions"
      ngassystemCO2emissions = ngsystemCO2*ngasprod
      ngassystemCH4emissions = ngsystemCH4*ngasprod
      ngassystemN2Oemissions = ngsystemN2O*ngasprod
      ngassystemCO2Eemissions = ngassystemCO2emissions +
     #    ngassystemCH4emissions*25 +ngassystemN2Oemissions*298
! Caluclate Coal Post Mining Emissions
      write (*,*) "Calculating Coal Processing Emissions"
      coalpostCO2emissions = coalpostCO2*coalprod
      coalpostCH4emissions = coalpostCH4*coalprod
      coalpostN2Oemissions = coalpostN2O*coalprod
      coalpostCO2Eemissions = coalpostCO2emissions +
     #    coalpostCH4emissions*25 + coalpostN2O*298
        ! Calcutalte Total Midstream Emissions
      write (*,*) "Calculating Midstream Emissions"
      midCO2 = refineryCO2emissions + ngassystemCO2emissions +
     #   coalpostCO2emissions
      midCH4 = refineryCH4emissions + ngassystemCH4emissions +
     #   coalpostCH4emissions
      midN2O = refineryN2Oemissions + ngassystemN2Oemissions +
     #   coalpostN2Oemissions
      midCO2E = midCO2 + midCH4*25 + midN2O*298
! Calculate CO2e emissions from Onsite Emissions
      write (*,*) "Calculating Onsite Emissions"
         CO2Eonem = CO2onem + CH4onem*25 + N2Oonem*298

! Calculate Grand Total
      write (*,*) "Calculating Total Emissions."
         totalCO2 = CO2onem + refineryCO2emissions +
     # ngassystemCO2emissions + coalpostCO2emissions + 
     # oilsconsumpCO2 + ngasconsumpCO2 + coalconsumpCO2

         totalCH4 = CH4onem + refineryCH4emissions +
     # ngassystemCH4emissions + coalpostCH4emissions + 
     # oilsconsumpCH4 + ngasconsumpCH4 + coalconsumpCH4

         totalN2O = N2Oonem + refineryN2Oemissions +
     # ngassystemN2Oemissions + coalpostN2Oemissions + 
     # oilsconsumpN2O + ngasconsumpN2O + coalconsumpN2O

        totalCO2E = totalCO2 + totalCH4*25 + totalN2O*298
! Write to files
       write (*,*) "Writing total emissions to files."
       write(unit=60,fmt=500)pyear,totalCO2E,totalCO2,totalCH4,totalN2O
       write (*,*) "Writing upstream emissions to files."
       write (unit=61,fmt=500)pyear,CO2Eonem,CO2onem,CH4onem,N2Oonem
       write (*,*) "Writing midstream emissions to files."
       write (unit=62,fmt=500)pyear, midCO2E, midCO2, midCH4, midN2O
       write (*,*) "Writing downstream emissions to files."
       write (unit=63,fmt=500)pyear, downCO2E, downCO2, downCH4, downN2O
       enddo
       close (50)
       close (51)
       close (52)
       close (60)
       close (61)
       close (62)
       close (63)
      enddo

      endprogram Greenhouse Gas Lifecycle Emissions Model 
