       program GGLEM Substitution Preprocessing 
       implicit none
       real :: oilsprod, ngasprod, coalprod
       real :: oilssubs, ngassubs, coalsubs
       character*49 junktext
       integer*2 :: oilsnum,ngasnum,coalnum,areanum
       character*4 pyear
       integer*8 :: i, j, k, l, m, n
       character*22, dimension (:,:), allocatable :: oilsname,ngasname,
     #      coalname
       character*24, dimension (:,:), allocatable :: prodfilename,
     #      onemfilename 
       character*31, dimension (:,:), allocatable :: outfilename 
       integer*4, dimension (:,:), allocatable :: numyears
       real, dimension (:,:), allocatable :: substitutionrate
       character*13 subsname
!      *****************************************************************************
 100  format (i2)
 120  format (A33)
 130  format (A13,F6.2,F6.2,F6.2)
 200  format (A42,F7.0,F8.6,F11.9,F11.9)
 210  format (A22,F7.0,F8.0,F11.0,F11.0)
 300  format (A24)
 350  format (i3)
 400  format (A4,F13.0,F13.0,F13.0)

!  Load Parameters, only the areanum and years are needed 

      open (unit=20, file="Processing/fuel_parameters.txt", 
     #                           form="formatted", status="old")
       read (unit=20, fmt=100) oilsnum
       read (unit=20, fmt=100) ngasnum
       read (unit=20, fmt=100) coalnum
       read (unit=20, fmt=100) areanum
      close (20)

! Load Substitution Rates
      open (unit=22, file="Processing/substitution_rates.txt",
     #                           form="formatted", status="old")
       read (unit=22, fmt=120) junktext

       allocate ( substitutionrate (3,5) )
      do n=1,5
        read (unit=22, fmt=130) subsname,substitutionrate(1,n),
     #                 substitutionrate(2,n), substitutionrate(3,n)
        substitutionrate(1,n) = substitutionrate(1,n)/100
        substitutionrate(2,n) = substitutionrate(2,n)/100
        substitutionrate(3,n) = substitutionrate(3,n)/100
      enddo
      close (22)

!   Prepare all parameters
      if (MOD(areanum,2)==0) then
        areanum = areanum/2
        write (*,*) "Sub-projects detected:", areanum
      else
        write(*,*)"Error: prod and onem files are not equal in number.
     # Please correct error, and reprocess model."
      endif
      call sleep(5)

      allocate ( prodfilename (1,areanum) )
      allocate ( onemfilename (1,areanum) )
      allocate ( outfilename (1,areanum) )
      allocate ( numyears (1,areanum) )

! Collect Production
! Onsite emission filenames won't be used, but they share a file.
 
      open (unit=40, file="Processing/project_areas.txt",
     #                            form="formatted", status="old")
      open (unit=41, file="Processing/numyears.txt",
     #                            form="formatted", status="old")
       do l=1,areanum
        read (unit=40,fmt=300) onemfilename(1,l)
       enddo
       do l=1,areanum
        read (unit=40,fmt=300) prodfilename(1,l)
       enddo
       do l=1,areanum
        read (unit=41,fmt=350) numyears (1,l)
       enddo
      close (40)
      close (41)


! Read in Production
      do m=1,areanum
       open (unit=50, file=prodfilename(1,m),
     #                            form="formatted", status="old")
      write (*,*) "Estimaing for production file: ", prodfilename(1,m)
      call sleep(5)
!  Setup files for writting Output
        outfilename(1,m)(1:18) = "Input/Substitutes/" 
        outfilename(1,m)(19:31) = prodfilename(1,m)(12:24)
        open (unit=60, file=outfilename(1,m),
     #                            form="formatted",status="unknown")
       write (*,*) "Preparing output file:  ",outfilename(1,m)
       call sleep(5)
       do n=1,numyears(1,m)
         read (unit=50, fmt=400) pyear,oilsprod,ngasprod,coalprod
!  Convert all production to 1000s BTUs
         oilsprod = oilsprod*5800
         ngasprod = ngasprod*1028
         coalprod = coalprod*18495

! Calculate Substituted Production 
        write (*,*) "Calculating substituted production."
        call sleep(5)
         oilssubs=oilsprod*substitutionrate(1,1)+
     #            ngasprod*substitutionrate(2,1)+
     #            coalprod*substitutionrate(3,1)
         ngassubs=oilsprod*substitutionrate(1,2)+
     #            ngasprod*substitutionrate(2,2)+
     #            coalprod*substitutionrate(3,2)
         coalsubs=oilsprod*substitutionrate(1,3)+
     #            ngasprod*substitutionrate(2,3)+
     #            coalprod*substitutionrate(3,3)

      

! Convert back to individual units from 1000s BTUs
        oilssubs = oilssubs/5800
        ngassubs = ngassubs/1028
        coalsubs = coalsubs/18495
        write (*,*) "Substituted Oil:",oilssubs," bbls."
        write (*,*) "Substituted Natural Gas:",ngassubs," Mcf."
        write (*,*) "Substituted Coal:",coalsubs," short tons."
        call sleep(5)
! Write to files
       write (unit=60,fmt=400)pyear,oilssubs,ngassubs,coalsubs
       enddo
       close (50)
       close (60)
      enddo
      endprogram GGLEM Substitution Preprocessing 
